﻿<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Kalend" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page Language="c#" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Pracownicy uprawnieni do umowy na czas nieokreślony</title>
		<script runat="server">
    	
    class UmowaInfo {
        PracHistoria historia;
        public PracHistoria Historia {
            get { return historia; }
        }
        int numer;
        public int Numer {
            get { return numer; }
        }
        int ilośćUmówNaCzasOkreślony;
        public int IlośćUmówNaCzasOkreślony {
            get { return ilośćUmówNaCzasOkreślony; }
        }
        Date data33Miesiące20160222;
        public Date Data33Miesiące20160222 {
            get { return data33Miesiące20160222; }
        }
        public UmowaInfo(PracHistoria historia, int numer, int ilośćUmówNaCzasOkreślony, Date data33Miesiące20160222) {
            this.numer = numer;
            this.historia = historia;
            this.ilośćUmówNaCzasOkreślony = ilośćUmówNaCzasOkreślony;
            this.data33Miesiące20160222 = data33Miesiące20160222;
        }
    }

    class UmowaInfoComparer : IComparer {
        public int Compare(object x, object y) {
            UmowaInfo u1 = (UmowaInfo)x;
            UmowaInfo u2 = (UmowaInfo)y;
            int result = u1.Historia.Pracownik.CompareTo(u2.Historia.Pracownik);
            if (result == 0)
                result = u1.Numer.CompareTo(u2.Numer);
            return result;
        }
    }
    
    void dc_ContextLoad(Object sender, EventArgs e) {
        Date data = ((ActualDate)dc[typeof(ActualDate)]).Actual;
        ReportHeader1["DZIEN"] = data.ToString();

        ArrayList lista = new ArrayList();
        
        Row[] rows = (Row[])dc[typeof(Row[])];
        foreach (Pracownik pp in rows) {
            StatystykaZatrudnieniaWorker szw = new StatystykaZatrudnieniaWorker();
            szw.Pracownik = pp;
            if (szw.Data33Miesiące20160222 != Date.Empty && szw.Data33Miesiące20160222 < data)
                foreach (PracHistoria ph in szw.UmowyOPracę)
                    lista.Add(new UmowaInfo(ph, ph.Etat.NumerUmowy, szw.IlośćUmówNaCzasOkreślony, szw.Data33Miesiące20160222.AddDays(1)));
        }

        lista.Sort(new UmowaInfoComparer());
        Grid1.DataSource = lista;
    }
        
		</script>
		<meta content="False" name="vs_showGrid">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="UmowaNaCzasNieokreślony" method="post" runat="server">
			<EA:DATACONTEXT id="dc" runat="server" OnContextLoad="dc_ContextLoad"></EA:DATACONTEXT>
            <cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1"
                title="Pracownicy uprawnieni do umowy na czas nieokreślony (licznik 33 miesiące)|</strong>Na dzień:<strong> %DZIEN%"
				runat="server"></cc1:reportheader>
            <ea:grid id="Grid1" runat="server" GroupData0="Historia.Pracownik" GroupData1="Data33Miesiące20160222"
				GroupLine="{0} - data zmiany umowy terminowej na umowę na czas nieokreślony: {1}">
				<Columns>
					<ea:GridColumn Width="30" Align="Right" DataMember="Historia.Etat.OkresUmowy" Caption="Okres umowy"></ea:GridColumn>
					<ea:GridColumn Width="50" Align="Right" DataMember="Historia.Etat.TypUmowy" Caption="Typ umowy"></ea:GridColumn>
					<ea:GridColumn Align="Right" DataMember="Historia.Etat.Wydzial.Nazwa" Caption="Wydział"></ea:GridColumn>
				</Columns>
			</ea:grid><cc1:reportfooter id="ReportFooter1" runat="server" TheEnd="False"></cc1:reportfooter></form>
	</body>
</HTML>
